IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.Contrato_Fraccionar_Precio') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.Contrato_Fraccionar_Precio
END
GO

CREATE FUNCTION dbo.Contrato_Fraccionar_Precio(@pId_Contrato INT, @pPrecio DECIMAL(16,5), @pFecha DATETIME) 
RETURNS DECIMAL(16,5)
AS 

BEGIN

DECLARE @Retorno			DECIMAL(16,5)
DECLARE @Flag_Fracciona		CHAR(1)
DECLARE @Fecha_Hasta		DATETIME
DECLARE @Fecha_Desde		DATETIME
DECLARE @Fin_Mes			DATETIME
DECLARE @Dia_Fin_Mes		SMALLINT
DECLARE @Semana				SMALLINT
DECLARE @Dia				SMALLINT


SET		@Retorno = @pPrecio


SELECT	@Flag_Fracciona = T.Flag_Fracciona 
		,@Fecha_Hasta = C.Fecha_Hasta
		,@Fecha_Desde = C.Fecha_Desde
		FROM Contratos C, Contratos_Tipos T 
		WHERE C.Id_Tipo_Con = T.Id_Tipo_Con AND C.Id_Contrato = @pId_Contrato

IF UPPER(@Flag_Fracciona) IN ('D','S') 
BEGIN
    SET @Fin_Mes = dbo.CF_EOMONTH(@pFecha)
	SET @Dia_Fin_Mes = DATEPART(dd,@Fin_Mes)  --28,29,30,31
	
	IF DATEPART(mm,@pFecha) =  DATEPART(mm,@Fecha_Hasta) AND DATEPART(yy,@pFecha) = DATEPART(yy,@Fecha_Hasta) --fraciono por fin de contrato
	BEGIN
		SET @Dia = DATEPART(dd,@Fecha_Hasta)
		IF UPPER(@Flag_Fracciona) = 'S'                   --fracciono por semana
		BEGIN
			IF @Dia <= 7				SET @Semana = 1
			IF @Dia BETWEEN 8 AND 14	SET @Semana = 2
			IF @Dia BETWEEN 15 AND 21	SET @Semana = 3
			IF @Dia >= 22			    SET @Semana = 4
			SET @Retorno	= @Retorno / 4 * @Semana         
		END

		IF UPPER(@Flag_Fracciona) = 'D'                   -- fracciono por dia
		BEGIN
			SET @Retorno	= @Retorno *  @Dia / @Dia_Fin_Mes
		END
	END
	ELSE    -- Si no entro por finde del contrato verifico el inicio.
	BEGIN
		IF  DATEPART(mm,@pFecha) =  DATEPART(mm,@Fecha_Desde) AND DATEPART(yy,@pFecha) = DATEPART(yy,@Fecha_Desde)
		BEGIN
			SET @Dia = DATEPART(dd,@Fecha_Desde)
			IF UPPER(@Flag_Fracciona) = 'S'                       --fracciono por semana
			BEGIN
				IF @Dia <= 7				SET @Semana = 4
				IF @Dia BETWEEN 8 AND 14	SET @Semana = 3
				IF @Dia BETWEEN 15 AND 21	SET @Semana = 2
				IF @Dia >= 22			    SET @Semana = 1
				SET @Retorno	= @Retorno / 4 * @Semana         
															 
			END
			IF UPPER(@Flag_Fracciona) = 'D'                        -- fracciono por dia
			BEGIN
				SET @Retorno	= @Retorno *  (@Dia_Fin_Mes - @Dia) / @Dia_Fin_Mes
			END
		END
	END
END
					
RETURN ISNULL(@Retorno,0)
END
